/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */




/**
 * Presents log levels available to developers within the WDW-SDK
 */
typedef NS_ENUM(NSUInteger, WDWLogLevel) {

    /// No logs are produced by the WDW-SDK
    WDWLogLevelNone = 0,

    /// Only errors are logged
    WDWLogLevelError,

    /// Warnings and Errors are logged
    WDWLogLevelWarning,
    
    /// Errors, warnings and additional information are logged
    WDWLogLevelInfo
};



/**
 * Error codes produced by the WDW-SDK. More information on the errors in the SDK iOS integration guide.
 */
typedef NS_ENUM(NSUInteger, WDWSDKErrorCode) {
    
    /// Error is thrown when the user does not grant or withdraws the permissions required by the WDW-SDK: Background execution or push notification permissions (only if the WDW-SDK push is used).
    WDW_Permissions_Error = 1,
    
    /// Error is thrown on starting the WDW-SDK when the device does not include GPS hardware.
    WDW_UnsupportedHardware_Error = 2,
    
    /// Error is thrown on starting the WDW-SDK or in runtime when the user has disabled the Location Service, withdrawn the permission to use it, or did not provide access to precise location.
    WDW_GPS_Access_Error = 3
};
