/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

#define ALL [NSArray arrayWithObjects: @"AT", @"BA", @"BE", @"BG", @"CA", @"CH", @"CY", @"CZ", @"DE", @"DK", @"ES", @"FI", @"FR", @"GB", @"GR", @"HR", @"HU", @"IE", @"IT", @"LT", @"LU", @"NL", @"NO", @"PL", @"PT", @"RO", @"RS", @"SE", @"SI", @"SK", @"UA", @"US", nil ]
#define EUROPE [NSArray arrayWithObjects: @"AT", @"BA", @"BE", @"BG", @"CH", @"CY", @"CZ", @"DE", @"DK", @"ES", @"FI", @"FR", @"GB", @"GR", @"HR", @"HU", @"IE", @"IT", @"LT", @"LU", @"NL", @"NO", @"PL", @"PT", @"RO", @"RS", @"SE", @"SI", @"SK", @"UA", nil ]
#define USA [NSArray arrayWithObjects: @"US", nil]
#define NORTH_AMERICA [NSArray arrayWithObjects: @"CA", @"US", nil]
#define GERMANY [NSArray arrayWithObjects: @"DE" , nil]

#import "WDWClient.h"
#import "WDWPushConfiguration.h"

/**
 Helper class to configure and build `WDWClient` instances.
 ##Usage Example
 
        WDWClient *sdkInstance = [[[[[WDWClientBuilder new]
                                        withFleetID:@"UnitTest_Fleet"]
                                        withPushConfiguration:config]
                                        withLogLevel:WDWLogLevelError]
                                    build];
 */

@interface WDWBuilder : NSObject

/**
 * Sets fleet ID
 *
 * @param fleetID Fleet ID for your Application, provided by Bosch, required
 */
- (WDWBuilder *)withFleetID:(NSString *)fleetID;

/**
 * Sets the push configuration
 *
 * @param config preconfigured `WDWPushConfiguration` object, required
*/
- (WDWBuilder *)withPushConfiguration:(WDWPushConfiguration *)config;

/**
 * Sets desired log level
 *
 * @param level desired log level, default is `WDWLogLevelWarning`
 */
- (WDWBuilder *)withLogLevel:(WDWLogLevel)level;

/**
 * Sets the countries in which the WDW service shall be active.
 * If the method is not invoked, data will be generated in each country supported by the WDW-SDK.
 *
 * For convenience, the WDW-SDK provides a set of predefined lists of countries:
 *
 * + ALL - List of all countries supported by the WDW-SDK
 * + EUROPE - List of European countries supported by the WDW-SDK
 * + USA - List of USA countries supported by the WDW-SDK
 * + NORTH_AMERICA - List of North American countries supported by the WDW-SDK
 * + GERMANY - Only support for Germany
 *
 * @param supportedCountries List of countries your app wants to support
 *
 * @return returns WDW builder instance
 */
- (WDWBuilder *)withSupportedCountries:(NSArray *)supportedCountries;

/**
 * Creates `WDWClient` instance based on collected configuration
 */
- (WDWClient *)build;

/**
 * Retrieves the list of all supported countries
 *
 * @return retrieves the list of all supported countries
 */
+ (NSArray *)All;

/**
 * Retrieves the list of all supported countries in Europe
 *
 * @return retrieves the list of all supported countries in Europe
 */
+ (NSArray *)Europe;

/**
 * Retrieves the list of all supported countries in USA
 *
 * @return retrieves the list of all supported countries in USA
 */
+ (NSArray *)Usa;

/**
 * Retrieves the list of all supported countries in North America
 *
 * @return retrieves the list of all supported countries in North America
 */
+ (NSArray *)NorthAmerica;

/**
 * Retrieves the country code for Germany
 *
 * @return retrieves the country code for Germany
 */
+ (NSArray *)Germany;

@end


