/**
 * Copyright (c) 2019 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate,WDWClientDelegate {

    var window: UIWindow?
    var wdwClient:WDWClient?
    var token:Data?
    
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        application.registerForRemoteNotifications()
        return true
    }
    
    func application(_ application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data) {
        // Save received token
        token = deviceToken
        // Now ready to run the WDW-SDK
        buildSDK()
    }
    
    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
        
        print(" Push received "+userInfo.debugDescription)
        if wdwClient!.evaluatePushMesage(userInfo) == nil {
            // handle application -related push message
            print("Incoming push message is not related to WDW")
        }
        completionHandler(.newData)
    }
    
    func buildSDK() {
        let pushConfiguration = WDWPushConfiguration(pushToken: self.token,
                                                     server: "Enter Push Server URL",
                                                     variantID: "Enter Server Variant",
                                                     secret: "Enter Server Secret")
        wdwClient = WDWBuilder().withFleetID("Enter Fleet ID")?
            .withPushConfiguration(pushConfiguration)?
            .withLogLevel(WDWLogLevel.info)
            .build()
        wdwClient?.delegate = self
    }

 //   MARK: WDWClient Delegates

    func wdwClient(_ client: WDWClient!, didEnterMonitoredArea areaId: String!) {
        // optional callback: get ready to receive data from the WDW-SDK
        // e.g. establish server connection
    }
    
    func wdwClient(_ client: WDWClient!, didLeftMonitoredArea areaId: String!) {
        // optional callback: get ready to stop receiving data from the WDW-SDK
        // e.g. close server connection
    }
    
    func wdwClient(_ client: WDWClient!, didReceiveDriving warning: WDWWarning!) {
        // display warning to user
    }
    
    func wdwClient(_ client: WDWClient!, didReceiveError error: Error!) {
        // handle errors
        let code = UInt(error._code)
        switch code {
        case WDWSDKErrorCode.WDW_Permissions_Error.rawValue:
            print("WDW_Permissions_Error")
        case WDWSDKErrorCode.WDW_UnsupportedHardware_Error.rawValue:
            print("WDW_UnsupportedHardware_Error")
        case WDWSDKErrorCode.WDW_GPS_Access_Error.rawValue:
            print("WDW_GPS_Access_Error")
        default:
            print("Undefined")
        }
    }
    
    func wdwClient(_ client: WDWClient!, didReceiveNewData json: String!) {
        // send data to server
    }
    
    //   MARK: UIApplication Delegates

    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }


}

