/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

#define ALL [NSArray arrayWithObjects:@"AT", @"BE", @"CH", @"CZ", @"DE", @"DK", @"ES", @"FI", @"FR", @"GB", @"GR", @"IE", @"IT", @"LT", @"LU", @"NL", @"NO", @"PL", @"PT", @"SE", nil ]
#define EUROPE [NSArray arrayWithObjects: @"AT", @"BE", @"CH", @"CZ", @"DE", @"DK", @"ES", @"FI", @"FR", @"GB", @"GR", @"IE", @"IT", @"LT", @"LU", @"NL", @"NO", @"PL", @"PT", @"SE", nil ]
#define GERMANY [NSArray arrayWithObjects: @"DE" , nil]

#import "WDWClient.h"
#import "WDWPushConfiguration.h"

/**
 Helper class to configure and build WDWClient instances.
 ##Usage Example
 
        WDWClient *sdkInstance = [[[[[WDWClientBuilder new]
                                        withFleetID:@"UnitTest_Fleet"]
                                        withPushConfiguration:config]
                                        withLogLevel:WDWLogLevelError]
                                    build];
 */

@interface WDWBuilder : NSObject

/** @brief Sets fleet ID
 *  @param fleetID Fleet ID for your Application, provided by Bosch, required
 */
- (WDWBuilder *)withFleetID:(NSString *)fleetID;

/** @brief Sets the push configuration
 *  @param config preconfigured WDWPushConfiguration object, required
*/
- (WDWBuilder *)withPushConfiguration:(WDWPushConfiguration *)config;

/** @brief Sets desired log level
 *  @param level desired log level, default is WDWLogLevelWarning
 */
- (WDWBuilder *)withLogLevel:(WDWLogLevel)level;

/** @brief Sets the countries in which the WDW service shall be active.
 *  If the method is not invoked, data will be generated in each country supported by the WDW-SDK.
 *
 *  For convenience, the WDW-SDK provides a set of predefined lists of countries.
 *  ALL - List of all countries supported by the WDW-SDK
 *  EUROPE - List of European countries supported by the WDW-SDK
 *  GERMANY - Only support for Germany
 *
 *  @param supportedCountries List of countries your app wants to support
 *  @return returns WDW builder instance
 */
- (WDWBuilder *)withSupportedCountries:(NSArray *)supportedCountries;

/** @brief Creates WDWClient instance based on collected configuration
 */
- (WDWClient *)build;

/** @brief retrieves the list of all supported countries
 *  @return retrieves the list of all supported countries
 */
+ (NSArray *)All;

/** @brief retrieves the list of all supported countries in Europe
 *  @return retrieves the list of all supported countries in Europe
 */
+ (NSArray *)Europe;

/** @brief retrieves the country code for Germany
 *  @return retrieves the country code for Germany
 */
+ (NSArray *)Germany;

@end


