/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */



/** Specifies all the possible WDW client availability states */
typedef NS_ENUM(NSUInteger, WDWClientAvailability) {
    WDWClientUnavailable = 0, ///< WDW client is not yet initialized or has some error which requires user attention
    WDWClientTemporarilyUnavailable = 1, ///< WDW client is temporarily unavailable but will try to autorecover its state
    WDWClientAvailable = 2, ///< WDW client is fully operational
} DEPRECATED_MSG_ATTRIBUTE("The availablity feature is deprecated from version 3.2.0");


/** Presents log levels available to developers within the WDW-SDK */
typedef NS_ENUM(NSUInteger, WDWLogLevel) {
    WDWLogLevelNone = 0, ///< No logs are produced by the WDW-SDK
    WDWLogLevelError, ///< Only errors are logged
    WDWLogLevelWarning, ///< Warnings and Errors are logged
    WDWLogLevelInfo ///< Internal information is logged as well as errors and warnings. You might want to provide these logs to Bosch when requesting technical support.
};



/** Error codes produced by WDW-SDK, more info in 'List of Errors' documentation section.
 */
typedef NS_ENUM(NSUInteger, WDWSDKErrorCode) {
    WDW_Permissions_Error = 1,///<WDW-SDK is stopped because background execution permission is not granted or withdrawn by the user. Ask user to grant required permissions.
    WDW_UnsupportedHardware_Error = 2, ///<WDW-SDK failed to start because iOS device lacks necessary sensors. Do not start SDK again on that device.
    WDW_GPS_Access_Error = 3, ///<WDW-SDK is stopped because Location services are disabled or user has denied the access. Ask user to enable location access.

};
