/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */


#import <Foundation/Foundation.h>

/** Helper class to encapsulate Push Server configuration parameters.
*/
@interface WDWPushConfiguration : NSObject

/**
* @brief Constructs the configuration object for push notifications
* @param token Apple push notification token that you have received in the Application delegate, required
* @param url Push registration server URL, provided to you by Bosch, required
* @param variant Server variant ID, provided to you by Bosch, required
* @param secret Server access secret, provided to you by Bosch, required
*/
- (id)initWithPushToken:(NSData *)token server:(NSString *)url variantID:(NSString *)variant secret:(NSString *)secret;

@property (strong, nonatomic) NSData *token;
@property (strong, nonatomic) NSString *serverURL;
@property (strong, nonatomic) NSString *serverVariant;
@property (strong, nonatomic) NSString *serverSecret;



@end
