/*
 * Copyright (c) 2017 Bosch SoftTec GmbH All Rights Reserved.
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.bosch.wdw.sampleapp;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Bundle;

import androidx.core.app.ActivityCompat;

import com.bosch.wdw.Error;
import com.bosch.wdw.WDWBuilder;
import com.bosch.wdw.WDWClient;
import com.bosch.wdw.WDWClientCallback;
import com.bosch.wdw.WarningEvent;

public class WDW_SDK_SampleActivity extends Activity {

  private WDWClient wdwClient;

  /**
   *  Create WDWClientCallback to receive WDW-SDK output
   */
  private WDWClientCallback wdwClientCallback = new WDWClientCallback() {
    @Override
    public void onAreaEntered(String tripId) {
      // Will be called if a relevant area will be entered.
      // A connection to the backend could be established.
    }

    @Override
    public void onAreaLeft(String tripId) {
      // Will be called if a relevant area is left.
      // The connection to the backend could be closed.
    }

    @Override
    public void onDataCollected(String s) {
      // onDataCollected provides data as a String, which should be send to the backend.
    }

    @Override
    public void onErrorOccured(Error error) {
      // Will be called if an error occurred.
    }

    @Override
    public void onWarningReceived(WarningEvent warningEvent) {
      // Called if a Wrong way driver warning arrives.
    }
  };


  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(com.bosch.wdw.sampleapp.R.layout.activity_system_demo);

    // Initializing the WDW-SDK and start monitoring.
    if(ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
      init_WDWSDK();
    } else {
      ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 23);
    }
  }

  @Override
  public void onRequestPermissionsResult (int requestCode, String[] permissions, int[] grantResults) {
    if(grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
      init_WDWSDK();
    }

  }

  /**
   * This method is showing how to create and start an instance of the WDW-SDK.
   */
  public void init_WDWSDK() {
    wdwClient = new WDWBuilder(this.getApplicationContext(), wdwClientCallback, "YourFleetId").build();
    wdwClient.startMonitoring();
  }

  /**
   * The monitoring of the SDK can be stopped at any time, depending on the use case of actual app.
   * Once started, the SDK will continue monitoring, even if the App is in background.
   * To stop the SDK from monitoring in the background,
   * the method {@link WDWClient#stopMonitoring} needs to be called during onStop().
   * For simplicity, onDestroy is used here.
   */
  @Override
  protected void onDestroy() {
    if(wdwClient != null) {
      wdwClient.stopMonitoring();
    }
    super.onDestroy();
  }
}
