/*
 * Copyright (c) 2019 Bosch SoftTec GmbH All Rights Reserved.
 * This software is the confidential and proprietary information of Bosch
 * SoftTec GmbH ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Bosch SoftTec (BSOT).
 *
 * BSOT MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. BSOT SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package com.bosch.wdw.sampleapp.kotlin

import android.Manifest
import android.os.Bundle
import android.support.v4.app.ActivityCompat
import android.support.v7.app.AppCompatActivity
import android.view.View
import android.widget.ToggleButton
import com.bosch.wdw.Error
import com.bosch.wdw.WDWBuilder
import com.bosch.wdw.WDWClient
import com.bosch.wdw.WDWClientCallback
import com.bosch.wdw.WarningEvent

class SampleActivity : AppCompatActivity() {

    private var wdwClient: WDWClient? = null

    // Callback to react on the output of the WDW-SDK
    private val wdwClientCallback = object: WDWClientCallback {

        override fun onAreaEntered(tripId: String?) {
            // Will be called if a relevant area will be entered.
            // A connection to the backend could be established.
        }

        override fun onDataCollected(data: String?) {
            // onDataCollected provides data as a String, which should be send to the backend.
        }

        override fun onWarningReceived(warningEvent: WarningEvent?) {
            // Called if a Wrong way driver warning arrives.
        }

        override fun onAreaLeft(tripId: String?) {
            // Will be called if a relevant area is left.
            // The connection to the backend could be closed.
        }

        override fun onErrorOccured(error: Error?) {
            // Will be called if an error occurred.
        }

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_sample)

        // Create an instance of the WDW-SDK
        wdwClient = WDWBuilder(applicationContext,wdwClientCallback,"YourFleetID").build()

        ActivityCompat.requestPermissions(this, arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 23)
    }

    /**
     * Handle the lifecycle of the WDW-SDK. The WDW-SDK will be actively monitoring the
     * user location from the point of calling {@link WDWClient#startMonitoring} until
     * it is explicitly stopped by calling {@link WDWClient#stopMonitoring}. Depending
     * on the API Level, the WDW-SDK will also keep on monitoring when the app is in
     * background.
     */
    fun onButtonClick(view: View) {
        if((view as ToggleButton).isChecked) {
            // Start the WDW-SDK
            wdwClient?.startMonitoring()
        } else {
            // Stop the WDW-SDK
            wdwClient?.stopMonitoring()
        }
    }
}
